<?php
session_start();

define('IP_LIST_FILE', 'ip_list.txt');

function ipMatches($ip, $pattern) {
    $pattern = preg_quote($pattern, '/');
    $pattern = str_replace('xx', '[0-9]{1,3}', $pattern);
    return preg_match('/^' . $pattern . '$/', $ip);
}

function isBanned($ip) {
    if (!file_exists(IP_LIST_FILE)) return false;

    $bannedIps = file(IP_LIST_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    foreach ($bannedIps as $bannedIp) {
        if (ipMatches($ip, trim($bannedIp))) {
            return true;
        }
    }

    return false;
}

function getVisitorIP2() {
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        return $_SERVER['HTTP_CF_CONNECTING_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } else {
        return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    }
}


$ip = getVisitorIP2();

if (isBanned($ip)) {
    http_response_code(500);
    exit("Internal Server Error");
}

?>
